#########################################################################################
# Alessandro Bugliarelli 2023
# JLNT TCAD modeling
# 5 STAGES RING OSCILLATOR STATIC OUTPUT CHARACTERISTICS - 20 NM DEVICE
# RESISTIVE LOAD WITH PULLDOWN TRANSISTOR - VD = -1.1 V
# LOGIC 0 = -1.1 V  LOGIC 1 = 0 V
#########################################################################################
Device PMOS {
	File {
		Grid		= "ring_oscillator_msh.tdr"
		Plot		= "ring_oscillator"
		Current		= "ring_oscillator"
		Parameter	= "ring_oscillator.par"
	}

	Electrode {
		{ name="Source"    Voltage=0.0 }
		{ name="Drain"     Voltage=0.0 DistResist = SchottkyResist }
		{ name="Gate"      Voltage=0.0 }
	}

	Physics{
		Fermi
		Mobility( DopingDep HighFieldSaturation ( ParameterSetName = "myHighField" ) Enormal )
		EffectiveIntrinsicDensity( Bennett )
		Recombination(
		SRH( DopingDep )
#		Band2Band (
#			Model = Hurkx
#			DensityCorrection = Local 
#			ParameterSetName = ("myBTBT") )
		)
		eQuantumPotential
		hQuantumPotential
	}

	Physics(MaterialInterface = "Silicon/SiO2"){
		Traps(
			Acceptor Level EnergyMid=-0.3 fromMidBandGap 
			Conc=4.0e11 eXsection=1e-14  hXsection=1e-14
		)
	}
}

Math{
	NumberOfThreads= 32
	Extrapolate
	RelErrControl
	Digits=4
 	Notdamped=50
  	Iterations=45
  	Transient=BE
  	Method=Blocked
  	SubMethod=ParDiSo
}

Plot{
	NonLocal
	eDensity hDensity
	eCurrent hCurrent
	TotalCurrent/Vector eCurrent/Vector hCurrent/Vector
	eMobility hMobility
	eVelocity hVelocity
	eEnormal hEnormal
	ElectricField/Vector Potential SpaceCharge
	eQuasiFermi hQuasiFermi
	Potential Doping SpaceCharge
	SRH Auger 
	AvalancheGeneration
	DonorConcentration AcceptorConcentration
	Doping
	eGradQuasiFermi/Vector hGradQuasiFermi/Vector
	eEparallel hEparalllel
	BandGap 
	BandGapNarrowing
	Affinity
	ConductionBand ValenceBand
	eQuantumPotential 
	hQuantumPotential
}

File {
	Output = "@log@"
}

System {
	Vsource_pset vdd (dd 0) { dc = 0.0 }

	PMOS M1 ( "Drain" = out1 "Gate" = out5 "Source" = 0 )
	Resistor_pset R1 ( dd out1 ){ resistance = 100e6 }
#	Capacitor_pset C1 ( out1 0 ){ capacitance = 1e-15 }

	PMOS M2 ( "Drain" = out2 "Gate" = out1 "Source" = 0 )
	Resistor_pset R2 ( dd out2 ){ resistance = 100e6 }
#	Capacitor_pset C2 ( out2 0 ){ capacitance = 1e-15 }

	PMOS M3 ( "Drain" = out3 "Gate" = out2 "Source" = 0 )
	Resistor_pset R3 ( dd out3 ){ resistance = 100e6 }
#	Capacitor_pset C3 ( out3 0 ){ capacitance = 1e-15 }

	PMOS M4 ( "Drain" = out4 "Gate" = out3 "Source" = 0 )
	Resistor_pset R4 ( dd out4 ){ resistance = 100e6 }
#	Capacitor_pset C4 ( out4 0 ){ capacitance = 1e-15 }

	PMOS M5 ( "Drain" = out5 "Gate" = out4 "Source" = 0 )
	Resistor_pset R5 ( dd out5 ){ resistance = 100e6 }
#	Capacitor_pset C5 ( out5 0 ){ capacitance = 1e-15 }

	initialize ( out1=-0.25 out2=-0.25 out3=-0.25 out4=-0.25 out5=-0.25 )
	Plot "n@node@_sys_des.plt" (time() v(out1) v(out2) v(out3) v(out4) v(out5))
}

Solve {  
	NewCurrentPrefix="init"
	Coupled(Iterations=100){ Poisson }
	Coupled{ Poisson Electron Hole Contact Circuit }

	Quasistationary( 
	InitialStep=0.05 MaxStep=0.05 MinStep=0.0001
	Goal{ Parameter=vdd.dc Voltage= -1.6 } 
	){ Coupled{ M1.poisson M1.electron M1.hole M1.contact
				M2.poisson M2.electron M2.hole M2.contact
				M3.poisson M3.electron M3.hole M3.contact
				M4.poisson M4.electron M4.hole M4.contact
				M5.poisson M5.electron M5.hole M5.contact circuit }
	}

	NewCurrentPrefix=""
	Transient( 
	InitialTime=0.0 FinalTime= 1.0e-8
	InitialStep=5e-13 Increment=1.35 
	MinStep=1e-14 MaxStep=2e-11
	){ Coupled{ M1.poisson M1.electron M1.hole M1.contact
				M2.poisson M2.electron M2.hole M2.contact
				M3.poisson M3.electron M3.hole M3.contact
				M4.poisson M4.electron M4.hole M4.contact
				M5.poisson M5.electron M5.hole M5.contact circuit }
	}
}

